/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer.sid;

import emulator.hardware.HwWord;
import emulator.util.AddressRange;
import emulator.util.file.FileInfo;
import emulator.util.file.FileInfoSid;
import java.io.PrintStream;

public class SidInfo {
    private int start_address;
    private int block_size;
    private int init_address;
    private int exec_address;
    private int song_count;
    private int start_song;
    private String title;
    private String author;
    private String year;

    public void init(int start_address, int block_size) {
        this.start_address = start_address;
        this.block_size = block_size;
        this.init_address = start_address;
        this.exec_address = start_address + 3;
        this.song_count = 1;
    }

    public SidInfo(FileInfo info) {
        this.init(info.getStartAddress(), info.getBlockSize());
        FileInfoSid sid_file = null;
        try {
            sid_file = (FileInfoSid)info;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (sid_file != null) {
            this.song_count = sid_file.getSongCount();
            if (sid_file.getInitAddress() > 0) {
                this.init_address = sid_file.getInitAddress();
            }
            if (sid_file.getExecAddress() > 0) {
                this.exec_address = sid_file.getExecAddress();
            }
            this.start_song = sid_file.getStartSong();
            this.title = sid_file.getTitle();
            this.author = sid_file.getAuthor();
            this.year = sid_file.getYear();
        }
    }

    public int getStartAddress() {
        return this.start_address;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public int getInitAddress() {
        return this.init_address;
    }

    public int getExecAddress() {
        return this.exec_address;
    }

    public int getSongCount() {
        return this.song_count;
    }

    private int getStartSong() {
        return this.start_song;
    }

    public void print(PrintStream out) {
        out.println("Code: " + this.getCodeRange());
        out.println("  Init: $" + new HwWord((long)this.getInitAddress()));
        out.println("  Play: $" + new HwWord((long)this.getExecAddress()));
        out.println(" Songs: " + this.getSongCount() + "  Default: " + this.getStartSong());
    }

    public AddressRange getCodeRange() {
        AddressRange range = new AddressRange();
        range.setStart(this.getStartAddress());
        range.setEnd(this.getStartAddress() + this.getBlockSize() - 1);
        return range;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getYear() {
        return this.year;
    }
}

